//
//  Sending_HTTP_DELETE_Requests_with_NSURLConnectionAppDelegate.m
//  Sending HTTP DELETE Requests with NSURLConnection
//
//  Created by Vandad Nahavandipoor on 19/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Sending_HTTP_DELETE_Requests_with_NSURLConnectionAppDelegate.h"

@implementation Sending_HTTP_DELETE_Requests_with_NSURLConnectionAppDelegate

@synthesize window = _window;

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  NSString *urlAsString = @"http://pixolity.com/delete.php";
  urlAsString = [urlAsString stringByAppendingString:@"?parametr1=Pierwszy"];
  urlAsString = [urlAsString stringByAppendingString:@"&parametr2=Drugi"];
  
  NSURL *url = [NSURL URLWithString:urlAsString];
  
  NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:url];
  [urlRequest setTimeoutInterval:30.0f];
  [urlRequest setHTTPMethod:@"DELETE"];
  
  NSString *body = @"bodyParametr1=bodyWartosc1&bodyParametr2=bodyWartosc2";
  [urlRequest setHTTPBody:[body dataUsingEncoding:NSUTF8StringEncoding]];
  
  NSOperationQueue *queue = [[NSOperationQueue alloc] init];
  
  [NSURLConnection
   sendAsynchronousRequest:urlRequest
   queue:queue
   completionHandler:^(NSURLResponse *response, 
                       NSData *data, 
                       NSError *error) {
     
     if ([data length] >0  &&
         error == nil){
       NSString *html = [[NSString alloc] initWithData:data
                                              encoding:NSUTF8StringEncoding];
       NSLog(@"HTML = %@", html);
     }
     else if ([data length] == 0 &&
              error == nil){
       NSLog(@"Nie pobrano żadnych danych.");
     }
     else if (error != nil){
       NSLog(@"Wystąpił błąd = %@", error);
     }
     
   }];
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
